#version 130
#extension GL_ARB_gpu_shader5 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// A Plethora of PentagonsMod01.fsh  by mla   
//https://www.shadertoy.com/view/WtdBWj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

////////////////////////////////////////////////////////////////////////////////
//
// Dual snub hexagonal tiling (so the tiles are generally pentagons).
// Matthew Arcus, mla, 2021
//
// Wythoff construction, with the Wythoff point varying across the plane.
// Inspired by Craig S. Kaplan: https://twitter.com/cs_kaplan/status/1361089568229974017
// 
// <mouse>: Uniform tiling across plane
//
////////////////////////////////////////////////////////////////////////////////

const float X = sqrt(3.0);
// Start Common  //
vec2 reflection(vec2 p, vec2 q, vec2 r) {
  // reflect p in the line through q and r
  p -= q;
  vec2 n = (r-q).yx * vec2(1,-1);
  p -= 2.0*dot(p,n)*n/dot(n,n);
  p += q;
  return p;
}

float segment(vec2 p, vec2 a, vec2 b) {
  vec2 pa = p - a;
  vec2 ba = b - a;
  float h = clamp(dot(pa, ba) / dot(ba, ba), 0.0, 1.0);
  float d = length(pa - ba * h);
  return d;
}

float line(vec2 p, vec2 a, vec2 b) {
  vec2 pa = p-a;
  vec2 ba = b-a;
  float h = dot(pa,ba)/dot(ba,ba);
  return length(pa - ba * h);
}

vec2 rotate(vec2 p, float t) {
  return cos(t)*p + sin(t)*vec2(-p.y,p.x);
}
// End Common  //

float drawone(vec2 z, vec2 t0, float d) {
  d = min(d,segment(z,t0,vec2(0)));
  d = min(d,segment(z,t0,vec2(X,0)));
  d = min(d,segment(z,t0,vec2(0,1)));

  d = min(d,segment(-z,t0,vec2(0)));
  d = min(d,segment(-z,t0,vec2(X,0)));
  d = min(d,segment(-z,t0,vec2(0,1)));
  return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{          
  vec2 z = (2.0*fragCoord-iResolution.xy)/iResolution.y;
  z = rotate(z,0.05*iTime);
  z *= 16.0;
  vec2 z0 = z;

  const mat2 M = mat2(X,-3,X,3);
  z.x += X;
  z = inverse(M)*z; // Convert to square grid
  z -= floor(z);
  z = M*z; // Back to triangles
  z.x -= X;

  if (z.y < 0.0) z = -z; // Rotate lower triangle to upper.

  // Rotational symmetry about triangle centre, so map centre of triangle to origin...
  z.y -= 1.0;

  // ...and reflect in planes of symmetry of triangle
  const vec2 A = normalize(vec2(1,X));
  const vec2 B = normalize(vec2(-1,X));
  int parity = 0;
  float ta = dot(z,A);
  if (ta < 0.0) z -= 2.0*ta*A;
  float tb = dot(z,B);
  if (tb < 0.0) z -= 2.0*tb*B;
  if (int(ta>0.0) + int(tb>0.0) == 1) z.x = -z.x; // Want even number of reflections
  z.y += 1.0;        // Shift origin back to region centre,

  float pwidth = fwidth(z0.x);
  
  vec3 col0 = vec3(0);
  vec3 col1 = vec3(0.9);//vec3(1,0,0);
  vec3 col2 = vec3(0.95);//vec3(1,1,0);

  float d = min(abs(z.x),z.y);
  d = min(d,line(abs(z),vec2(0,1),vec2(X,0)));
  float mfact = smoothstep(-pwidth,pwidth,d);
  vec3 col = mix(col1,col2,(z.x < 0.0 ? mfact : mfact-1.0));
  
  vec2 z1 = vec2(-1,1)*reflection(z,vec2(X,0),vec2(0,1));
  vec2 z2 = reflection(vec2(-1,1)*z,vec2(X,0),vec2(0,1));
  vec2 t0 = (fragCoord.xy-0.5*iResolution.xy)/iResolution.y;
  if (iMouse.z > 0.0) t0 = (iMouse.xy-0.5*iResolution.xy)/iResolution.y;
  t0 = 1.2*rotate(t0,-0.2*iTime);
  
  d = 1e8;
  d = drawone(z,t0,d);
  d = drawone(z1,t0,d);
  d = drawone(z2,t0,d);

  col = mix(col0,col,smoothstep(0.015,0.015+1.25*pwidth,d));

  fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
gl_FragColor.a = length ( vec3(0.5) - gl_FragColor.rgb );
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

